/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIFspString;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspLocationCodeInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspVspAttr;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.frame.OmFrameMgr;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbemcfg.GlobalConfig;

public class PILedFunctions {
    private static final String TRACE_MASK = "apcshscT";
    private static final boolean CALL_BY_VALUE = GlobalConfig.callMethodsWithValues;
    private static final int PAD = 0;
    private static final int PHY_SA_LED = 1;
    private static final int SYS_FLAG = 0;
    private static final String DUMMY_STRING = "000";
    private static final int IND_MASK = 1;
    private static final int SET_IND_BASE_LEN = 10;
    private static final int SET_IND_ARGS = 6;
    private static final int GET_IND_ARGS = 4;
    private static final int GET_IND_BASE_LEN = 4;
    private static final int GET_LOCCODE_INFO_LEN = 6;
    public static final String SYS_TAG = "sys";
    public static final String ENCL = "encl";
    public static final String INDICATOR_LIST = "IndicatorStateList";
    public static final String LED_STATE_LIST = "LedStateList";
    public static final String ENCL_CODE_LIST = "EnclosureLocCodeList";
    public static final String FRU_TYPE_LIST = "FRUTypeList";
    public static final String INDICATOR_STATE_LIST = "IndicatorStateList";
    public static final String LOC_CODE_LIST = "LocCodeList";
    public static final String RESOURCE_STATUS_LIST = "ResourceStatusList";
    public static final String STATUS_LIST = "StatusList";
    public static final String LED_STATE = "LedState";
    public static final String SYS_LOC_CODE = "SystemLocationCode";
    public static final String FRU_TYPE = "FRUType";
    public static final String RESRC_STATUS = "Status";
    public static final String INDICATOR_STATE = "IndicatorState";
    public static final String ENCLOSURE = "Enclosure";
    public static final String ENCLOSURE_MAP = "EnclosureMap";
    public static final UnsignedInt16 SET_ALL_SYS_INDICATORS = new UnsignedInt16(Short.MIN_VALUE);
    public static final UnsignedInt16 SET_ALL_ENCL_INDICATORS = new UnsignedInt16(16384);
    public static final UnsignedInt16 SET_SINGLE_INDICATOR = new UnsignedInt16(1);
    public static final UnsignedInt16 SYS_LOC_INFO = new UnsignedInt16(Short.MIN_VALUE);
    public static final UnsignedInt16 ENCL_LIST_INFO = new UnsignedInt16(16384);
    public static final UnsignedInt16 ALL_LOCCODE_INFO = new UnsignedInt16(8192);
    public static final UnsignedInt16 LC_CODE_INFO = new UnsignedInt16(256);
    public static final UnsignedInt16 ABORT = new UnsignedInt16(1);
    public static final UnsignedInt16 LOCCODE_LIST_ID = new UnsignedInt16(10);
    private static UnsignedInt16[] REQUEST_TYPE_MAP = new UnsignedInt16[]{SYS_LOC_INFO, ENCL_LIST_INFO, ALL_LOCCODE_INFO, LC_CODE_INFO, ABORT};
    private static UnsignedInt16[] SET_INDICATOR_MAP = new UnsignedInt16[]{SET_ALL_SYS_INDICATORS, SET_ALL_ENCL_INDICATORS, SET_SINGLE_INDICATOR};
    private static final int INVALID_DATA = 3;
    private static final int INVALID_INDICATOR_STATE = 258;
    private static final int INDICATOR_BUSY = 257;
    private static final int INDICATOR_CMMD_FAILED = 261;
    private static final int INDICATOR_REQ_TYPE_NOT_SUPRTD = 262;
    private static final int COMMAND_BUSY = 28;
    private static final String BUNDLE_FILE = "HSCCIMExceptionBundle";
    private static final String INVALID_DATA_ID = "3003";
    private static final String INVALID_INDICATOR_ID = "3004";
    private static final String INDICATOR_BUSY_ID = "3005";
    private static final String COMMAND_FAILED_ID = "3002";
    private static final String INDICATOR_CMMD_FAILED_ID = "3006";
    private static final String INDICATOR_REQ_TYPE_ID = "3009";
    private static final String COMMAND_BUSY_ID = "3007";
    private static final String FOLLOWING_ERRORS_ID = "3008";

    public static CIMValue GetSystemLocationCodeInfo(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        block9: {
            if (PILedFunctions.tracing(Trace.LEVEL)) {
                PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetSystemLocationCodeInfo");
            }
            String string = null;
            String string2 = null;
            UnsignedInt8 unsignedInt8 = null;
            UnsignedInt8 unsignedInt82 = null;
            Iterator iterator = null;
            try {
                iterator = PILedFunctions._getLocationCodeInfo(omCecMgr, SYS_LOC_INFO, null);
                if (iterator == null || !iterator.hasNext()) break block9;
                FspLocationCodeInfo fspLocationCodeInfo = (FspLocationCodeInfo)iterator.next();
                string = fspLocationCodeInfo.getLocationCode();
                string2 = fspLocationCodeInfo.getCCIN();
                unsignedInt8 = fspLocationCodeInfo.getStatus();
                unsignedInt82 = fspLocationCodeInfo.getIndicatorState();
                try {
                    if (CALL_BY_VALUE) {
                        vector.add(new CIMValue((Object)string, new CIMDataType(9)));
                        vector.add(new CIMValue((Object)string2, new CIMDataType(9)));
                        vector.add(new CIMValue((Object)unsignedInt8, new CIMDataType(1)));
                        vector.add(new CIMValue((Object)unsignedInt82, new CIMDataType(1)));
                        break block9;
                    }
                    vector.add(new CIMProperty(SYS_LOC_CODE, new CIMValue((Object)string, new CIMDataType(9))));
                    vector.add(new CIMProperty(FRU_TYPE, new CIMValue((Object)string2, new CIMDataType(9))));
                    vector.add(new CIMProperty(RESRC_STATUS, new CIMValue((Object)unsignedInt8, new CIMDataType(1))));
                    vector.add(new CIMProperty(INDICATOR_STATE, new CIMValue((Object)unsignedInt82, new CIMDataType(1))));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            catch (PIHscServerException pIHscServerException) {
                throw pIHscServerException;
            }
            catch (Throwable throwable) {
                if (PILedFunctions.tracing()) {
                    PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetLocCodeList *** Error ***");
                    throwable.printStackTrace();
                }
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
            }
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetSystemLocationCodeInfo");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetSystemLocationCodeInfo(OmFrameMgr omFrameMgr, Vector vector) throws PIHscServerException {
        String string = null;
        String string2 = null;
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt8 unsignedInt82 = null;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetSystemLocationCodeInfo");
        }
        try {
            Vector vector2 = PILedFunctions._getLocationCodeInfo(omFrameMgr, SYS_LOC_INFO, null);
            if (vector2 != null) {
                System.out.println("********* BPA: GetSystemLocationCodeInfo:: LocationCodeInfo*******");
                for (int i = 0; i < vector2.size(); ++i) {
                    FspLocationCodeInfo fspLocationCodeInfo = (FspLocationCodeInfo)vector2.get(i);
                    System.out.println("BPA location code = " + fspLocationCodeInfo);
                    string = fspLocationCodeInfo.getLocationCode();
                    string2 = fspLocationCodeInfo.getCCIN();
                    unsignedInt8 = fspLocationCodeInfo.getStatus();
                    unsignedInt82 = fspLocationCodeInfo.getIndicatorState();
                }
            }
            if (CALL_BY_VALUE) {
                vector.add(new CIMValue(string, new CIMDataType(9)));
                vector.add(new CIMValue(string2, new CIMDataType(9)));
                vector.add(new CIMValue((Object)unsignedInt8, new CIMDataType(1)));
                vector.add(new CIMValue((Object)unsignedInt82, new CIMDataType(1)));
            } else {
                vector.add(new CIMProperty(SYS_LOC_CODE, new CIMValue(string, new CIMDataType(9))));
                vector.add(new CIMProperty(FRU_TYPE, new CIMValue(string2, new CIMDataType(9))));
                vector.add(new CIMProperty(RESRC_STATUS, new CIMValue((Object)unsignedInt8, new CIMDataType(1))));
                vector.add(new CIMProperty(INDICATOR_STATE, new CIMValue((Object)unsignedInt82, new CIMDataType(1))));
            }
        }
        catch (PIHscServerException pIHscServerException) {
            throw pIHscServerException;
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetLocCodeList *** Error ***");
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetSystemLocationCodeInfo");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetEnclosureList(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        Iterator iterator;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetEnclosureList");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<UnsignedInt8> arrayList2 = new ArrayList<UnsignedInt8>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<UnsignedInt8> arrayList4 = new ArrayList<UnsignedInt8>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            iterator = PILedFunctions._getLocationCodeInfo(omCecMgr, ENCL_LIST_INFO, null);
        }
        catch (PIHscServerException pIHscServerException) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetEnclosureList *** Error ***");
                pIHscServerException.printStackTrace();
            }
            if (!pIHscServerException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._CECClassLogInfo);
                pIHscServerException.setAlreadyLogged(true);
            }
            throw pIHscServerException;
        }
        if (iterator != null && iterator.hasNext()) {
            if (vector == null) {
                vector = new Vector<Object>(4);
            }
            while (iterator.hasNext()) {
                FspLocationCodeInfo fspLocationCodeInfo = (FspLocationCodeInfo)iterator.next();
                arrayList.add(fspLocationCodeInfo.getLocationCode());
                arrayList2.add(fspLocationCodeInfo.getIndicatorState());
                arrayList3.add(fspLocationCodeInfo.getCCIN());
                arrayList4.add(fspLocationCodeInfo.getStatus());
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            String[] stringArray2 = arrayList3.toArray(new String[0]);
            UnsignedInt8[] unsignedInt8Array = arrayList2.toArray(new UnsignedInt8[0]);
            UnsignedInt8[] unsignedInt8Array2 = arrayList4.toArray(new UnsignedInt8[0]);
            if (CALL_BY_VALUE) {
                vector.add(new CIMValue((Object)stringArray, new CIMDataType(29)));
                vector.add(new CIMValue((Object)stringArray2, new CIMDataType(29)));
                vector.add(new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21)));
                vector.add(new CIMValue((Object)unsignedInt8Array, new CIMDataType(21)));
            } else {
                vector.add(new CIMProperty(ENCL_CODE_LIST, new CIMValue((Object)stringArray, new CIMDataType(29))));
                vector.add(new CIMProperty(FRU_TYPE_LIST, new CIMValue((Object)stringArray2, new CIMDataType(29))));
                vector.add(new CIMProperty(RESOURCE_STATUS_LIST, new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21))));
                vector.add(new CIMProperty("IndicatorStateList", new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
            }
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetEnclosureList");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetEnclosureList(OmFrameMgr omFrameMgr, Vector vector) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetEnclosureList");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<UnsignedInt8> arrayList2 = new ArrayList<UnsignedInt8>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<UnsignedInt8> arrayList4 = new ArrayList<UnsignedInt8>();
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector2 = null;
        try {
            vector2 = PILedFunctions._getLocationCodeInfo(omFrameMgr, ENCL_LIST_INFO, null);
        }
        catch (PIHscServerException pIHscServerException) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetEnclosureList *** Error ***");
                pIHscServerException.printStackTrace();
            }
            if (!pIHscServerException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._CECClassLogInfo);
                pIHscServerException.setAlreadyLogged(true);
            }
            throw pIHscServerException;
        }
        if (vector2 != null) {
            System.out.println("********* BPA: GetEnclosureList:: LocationCodeInfo*******");
            for (int i = 0; i < vector2.size(); ++i) {
                if (vector == null) {
                    vector = new Vector<Object>(4);
                }
                FspLocationCodeInfo fspLocationCodeInfo = (FspLocationCodeInfo)vector2.get(i);
                System.out.println("BPA GetEnclosureList>>>>>>");
                System.out.println("BPA LocationCodeInfo ... " + fspLocationCodeInfo);
                arrayList.add(fspLocationCodeInfo.getLocationCode());
                arrayList2.add(fspLocationCodeInfo.getIndicatorState());
                arrayList3.add(fspLocationCodeInfo.getCCIN());
                arrayList4.add(fspLocationCodeInfo.getStatus());
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            System.out.println("CODES size = " + stringArray.length);
            String[] stringArray2 = arrayList3.toArray(new String[0]);
            UnsignedInt8[] unsignedInt8Array = arrayList2.toArray(new UnsignedInt8[0]);
            UnsignedInt8[] unsignedInt8Array2 = arrayList4.toArray(new UnsignedInt8[0]);
            if (CALL_BY_VALUE) {
                vector.add(new CIMValue((Object)stringArray, new CIMDataType(29)));
                vector.add(new CIMValue((Object)stringArray2, new CIMDataType(29)));
                vector.add(new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21)));
                vector.add(new CIMValue((Object)unsignedInt8Array, new CIMDataType(21)));
            } else {
                vector.add(new CIMProperty(ENCL_CODE_LIST, new CIMValue((Object)stringArray, new CIMDataType(29))));
                vector.add(new CIMProperty(FRU_TYPE_LIST, new CIMValue((Object)stringArray2, new CIMDataType(29))));
                vector.add(new CIMProperty(RESOURCE_STATUS_LIST, new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21))));
                vector.add(new CIMProperty("IndicatorStateList", new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
            }
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetEnclosureList");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetEnclosureLocationCodeInfo(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetEnclosureLocationCodeInfo");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<UnsignedInt8> arrayList3 = new ArrayList<UnsignedInt8>();
        ArrayList<UnsignedInt8> arrayList4 = new ArrayList<UnsignedInt8>();
        try {
            Object object;
            String string = CALL_BY_VALUE ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            Iterator iterator = PILedFunctions._getLocationCodeInfo(omCecMgr, ALL_LOCCODE_INFO, new PIFspString(string));
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object = (FspLocationCodeInfo)iterator.next();
                    arrayList.add(((FspLocationCodeInfo)object).getLocationCode());
                    arrayList2.add(((FspLocationCodeInfo)object).getCCIN());
                    arrayList4.add(((FspLocationCodeInfo)object).getIndicatorState());
                    arrayList3.add(((FspLocationCodeInfo)object).getStatus());
                }
            }
            object = arrayList4.toArray(new UnsignedInt8[0]);
            UnsignedInt8[] unsignedInt8Array = arrayList3.toArray(new UnsignedInt8[0]);
            String[] stringArray = arrayList2.toArray(new String[0]);
            String[] stringArray2 = arrayList.toArray(new String[0]);
            if (vector2 == null) {
                vector2 = new Vector<CIMValue>(4);
            }
            if (CALL_BY_VALUE) {
                vector2.add(new CIMValue((Object)stringArray2, new CIMDataType(29)));
                vector2.add(new CIMValue((Object)stringArray, new CIMDataType(29)));
                vector2.add(new CIMValue((Object)unsignedInt8Array, new CIMDataType(21)));
                vector2.add(new CIMValue(object, new CIMDataType(21)));
            } else {
                vector2.add((CIMValue)new CIMProperty(LOC_CODE_LIST, new CIMValue((Object)stringArray2, new CIMDataType(29))));
                vector2.add((CIMValue)new CIMProperty(FRU_TYPE_LIST, new CIMValue((Object)stringArray, new CIMDataType(29))));
                vector2.add((CIMValue)new CIMProperty(RESOURCE_STATUS_LIST, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
                vector2.add((CIMValue)new CIMProperty("IndicatorStateList", new CIMValue(object, new CIMDataType(21))));
            }
        }
        catch (PIHscServerException pIHscServerException) {
            throw pIHscServerException;
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetEnclosureLocationCodeInfo **** Error ****");
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetEnclosureLocationCodeInfo");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetEnclosureLocationCodeInfo(OmFrameMgr omFrameMgr, Vector vector, Vector vector2) throws PIHscServerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<UnsignedInt8> arrayList3 = new ArrayList<UnsignedInt8>();
        ArrayList<UnsignedInt8> arrayList4 = new ArrayList<UnsignedInt8>();
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetEnclosureLocationCodeInfo");
        }
        try {
            String string = CALL_BY_VALUE ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            Vector vector3 = PILedFunctions._getLocationCodeInfo(omFrameMgr, ALL_LOCCODE_INFO, new PIFspString(string));
            FspLocationCodeInfo fspLocationCodeInfo = null;
            if (vector3 != null) {
                System.out.println("********* BPA: GetEnclosureLocationCodeInfo:: LocationCodeInfo*******");
                for (int i = 0; i < vector3.size(); ++i) {
                    fspLocationCodeInfo = (FspLocationCodeInfo)vector3.get(i);
                    System.err.println("BPA GetEnclosureLocationCodeInfo >>> LocationCodInfo .." + fspLocationCodeInfo);
                    arrayList.add(fspLocationCodeInfo.getLocationCode());
                    arrayList2.add(fspLocationCodeInfo.getCCIN());
                    arrayList4.add(fspLocationCodeInfo.getIndicatorState());
                    arrayList3.add(fspLocationCodeInfo.getStatus());
                }
            }
            UnsignedInt8[] unsignedInt8Array = arrayList4.toArray(new UnsignedInt8[0]);
            UnsignedInt8[] unsignedInt8Array2 = arrayList3.toArray(new UnsignedInt8[0]);
            String[] stringArray = arrayList2.toArray(new String[0]);
            String[] stringArray2 = arrayList.toArray(new String[0]);
            if (vector2 == null) {
                vector2 = new Vector<CIMValue>(4);
            }
            if (CALL_BY_VALUE) {
                vector2.add(new CIMValue((Object)stringArray2, new CIMDataType(29)));
                vector2.add(new CIMValue((Object)stringArray, new CIMDataType(29)));
                vector2.add(new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21)));
                vector2.add(new CIMValue((Object)unsignedInt8Array, new CIMDataType(21)));
            } else {
                vector2.add((CIMValue)new CIMProperty(LOC_CODE_LIST, new CIMValue((Object)stringArray2, new CIMDataType(29))));
                vector2.add((CIMValue)new CIMProperty(FRU_TYPE_LIST, new CIMValue((Object)stringArray, new CIMDataType(29))));
                vector2.add((CIMValue)new CIMProperty(RESOURCE_STATUS_LIST, new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21))));
                vector2.add((CIMValue)new CIMProperty("IndicatorStateList", new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
            }
        }
        catch (PIHscServerException pIHscServerException) {
            throw pIHscServerException;
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetEnclosureLocationCodeInfo **** Error ****");
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetEnclosureLocationCodeInfo");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetLocationCodeInfo(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetLocationCodeInfo");
        }
        String[] stringArray = null;
        UnsignedInt8[] unsignedInt8Array = null;
        UnsignedInt8[] unsignedInt8Array2 = null;
        String[] stringArray2 = null;
        Iterator iterator = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            stringArray = CALL_BY_VALUE ? (String[])((CIMValue)vector.elementAt(0)).getValue() : (String[])((CIMProperty)vector.elementAt(0)).getValue().getValue();
            int n = stringArray.length;
            unsignedInt8Array = new UnsignedInt8[n];
            unsignedInt8Array2 = new UnsignedInt8[n];
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                try {
                    iterator = PILedFunctions._getLocationCodeInfo(omCecMgr, LC_CODE_INFO, new PIFspString(stringArray[i]));
                }
                catch (PIHscServerException pIHscServerException) {
                    if (PILedFunctions.tracing()) {
                        PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetLocationCodeInfo *** Error ***");
                        pIHscServerException.printStackTrace();
                    }
                    if (!pIHscServerException.alreadyLogged()) {
                        HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._CECClassLogInfo);
                        pIHscServerException.setAlreadyLogged(true);
                    }
                    throw pIHscServerException;
                }
                if (iterator == null || !iterator.hasNext()) continue;
                FspLocationCodeInfo fspLocationCodeInfo = (FspLocationCodeInfo)iterator.next();
                unsignedInt8Array2[i] = fspLocationCodeInfo.getIndicatorState();
                unsignedInt8Array[i] = fspLocationCodeInfo.getStatus();
                stringArray2[i] = fspLocationCodeInfo.getCCIN();
            }
            if (vector2 == null) {
                vector2 = new Vector<CIMValue>(3);
            }
            if (CALL_BY_VALUE) {
                vector2.setElementAt(new CIMValue((Object)stringArray2, new CIMDataType(29)), 0);
                vector2.setElementAt(new CIMValue((Object)unsignedInt8Array, new CIMDataType(21)), 1);
                vector2.setElementAt(new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21)), 2);
            } else {
                vector2.setElementAt((CIMValue)new CIMProperty(FRU_TYPE_LIST, new CIMValue((Object)stringArray2, new CIMDataType(29))), 0);
                vector2.setElementAt((CIMValue)new CIMProperty(STATUS_LIST, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))), 1);
                vector2.setElementAt((CIMValue)new CIMProperty("IndicatorStateList", new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21))), 2);
            }
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetLocationCodeInfo *** Error ***");
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetLocationCodeInfo");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue AbortLocationCodeCommand(OmCecMgr omCecMgr) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.AbortLocationCodeCommand");
        }
        PILedFunctions._getLocationCodeInfo(omCecMgr, ABORT, null);
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.AbortLocationCodeCommand");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetAllLocCodeInfo(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        UnsignedInt8 unsignedInt8;
        String[] stringArray;
        Object[] objectArray;
        Object object;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetAllLocCodes");
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<UnsignedInt8> arrayList3 = new ArrayList<UnsignedInt8>();
        ArrayList<UnsignedInt8> arrayList4 = new ArrayList<UnsignedInt8>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        Vector vector2 = new Vector();
        Vector<Object> vector3 = new Vector<Object>();
        boolean bl = false;
        try {
            PILedFunctions.GetSystemLocationCodeInfo(omCecMgr, vector2);
            if (vector2 != null && vector2.size() > 3) {
                if (CALL_BY_VALUE) {
                    arrayList.add(SYS_TAG);
                    arrayList2.add((String)((CIMValue)vector2.elementAt(0)).getValue());
                    arrayList3.add((UnsignedInt8)((CIMValue)vector2.elementAt(3)).getValue());
                    arrayList4.add((UnsignedInt8)((CIMValue)vector2.elementAt(2)).getValue());
                    arrayList5.add((String)((CIMValue)vector2.elementAt(1)).getValue());
                } else {
                    arrayList.add(SYS_TAG);
                    arrayList2.add((String)((CIMProperty)vector2.elementAt(0)).getValue().getValue());
                    arrayList3.add((UnsignedInt8)((CIMProperty)vector2.elementAt(3)).getValue().getValue());
                    arrayList4.add((UnsignedInt8)((CIMProperty)vector2.elementAt(2)).getValue().getValue());
                    arrayList5.add((String)((CIMProperty)vector2.elementAt(1)).getValue().getValue());
                }
            }
        }
        catch (PIHscServerException pIHscServerException) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetAllLocCodeInfo *** Error ***");
                pIHscServerException.printStackTrace();
            }
            throw pIHscServerException;
        }
        String[] stringArray2 = null;
        UnsignedInt8[] unsignedInt8Array = null;
        String[] stringArray3 = null;
        UnsignedInt8[] unsignedInt8Array2 = null;
        try {
            vector2 = new Vector();
            PILedFunctions.GetEnclosureList(omCecMgr, vector2);
            if (vector2 != null) {
                if (CALL_BY_VALUE) {
                    stringArray2 = (String[])((CIMValue)vector2.elementAt(0)).getValue();
                    stringArray3 = (String[])((CIMValue)vector2.elementAt(1)).getValue();
                    unsignedInt8Array2 = (UnsignedInt8[])((CIMValue)vector2.elementAt(2)).getValue();
                    unsignedInt8Array = (UnsignedInt8[])((CIMValue)vector2.elementAt(3)).getValue();
                } else {
                    stringArray2 = (String[])((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                    stringArray3 = (String[])((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                    unsignedInt8Array2 = (UnsignedInt8[])((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                    unsignedInt8Array = (UnsignedInt8[])((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    arrayList.add(ENCL);
                    object = stringArray2[i];
                    arrayList2.add(object);
                    arrayList3.add(unsignedInt8Array[i]);
                    arrayList5.add(stringArray3[i]);
                    arrayList4.add(unsignedInt8Array2[i]);
                    vector2 = new Vector();
                    vector3 = new Vector();
                    if (CALL_BY_VALUE) {
                        vector3.add(0, new CIMValue(object));
                    } else {
                        vector3.add(0, new CIMProperty(ENCLOSURE, new CIMValue(object)));
                    }
                    try {
                        PILedFunctions.GetEnclosureLocationCodeInfo(omCecMgr, vector3, vector2);
                        objectArray = null;
                        stringArray = null;
                        UnsignedInt8[] unsignedInt8Array3 = null;
                        UnsignedInt8[] unsignedInt8Array4 = null;
                        if (vector2 == null) continue;
                        if (CALL_BY_VALUE) {
                            objectArray = (String[])((CIMValue)vector2.elementAt(0)).getValue();
                            stringArray = (String[])((CIMValue)vector2.elementAt(1)).getValue();
                            unsignedInt8Array4 = (UnsignedInt8[])((CIMValue)vector2.elementAt(2)).getValue();
                            unsignedInt8Array3 = (UnsignedInt8[])((CIMValue)vector2.elementAt(3)).getValue();
                        } else {
                            objectArray = (String[])((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                            stringArray = (String[])((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                            unsignedInt8Array4 = (UnsignedInt8[])((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                            unsignedInt8Array3 = (UnsignedInt8[])((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                        }
                        for (int j = 0; j < objectArray.length; ++j) {
                            unsignedInt8 = objectArray[j];
                            if (unsignedInt8.equals(object)) continue;
                            arrayList.add(object);
                            arrayList2.add(unsignedInt8);
                            arrayList3.add(unsignedInt8Array3[j]);
                            arrayList4.add(unsignedInt8Array4[j]);
                            arrayList5.add(stringArray[j]);
                        }
                        continue;
                    }
                    catch (PIHscServerException pIHscServerException) {
                        if (PILedFunctions.tracing()) {
                            PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetAllLocCodeInfo *** Error ***");
                            pIHscServerException.printStackTrace();
                        }
                        throw pIHscServerException;
                    }
                }
            }
        }
        catch (PIHscServerException pIHscServerException) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetAllLocCodeInfo *** Error ***");
                pIHscServerException.printStackTrace();
            }
            throw pIHscServerException;
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetAllLocCodeInfo *** Error ***");
                throwable.printStackTrace();
            }
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (vector == null) {
            vector = new Vector<Object>(5);
        }
        object = arrayList.toArray(new String[0]);
        String[] stringArray4 = arrayList5.toArray(new String[0]);
        unsignedInt8 = arrayList3.toArray(new UnsignedInt8[0]);
        objectArray = arrayList4.toArray(new UnsignedInt8[0]);
        stringArray = arrayList2.toArray(new String[0]);
        try {
            if (CALL_BY_VALUE) {
                vector.add(new CIMValue(object, new CIMDataType(29)));
                vector.add(new CIMValue((Object)stringArray, new CIMDataType(29)));
                vector.add(new CIMValue((Object)stringArray4, new CIMDataType(29)));
                vector.add(new CIMValue((Object)objectArray, new CIMDataType(21)));
                vector.add(new CIMValue((Object)unsignedInt8, new CIMDataType(21)));
            } else {
                vector.add(new CIMProperty(ENCLOSURE_MAP, new CIMValue(object, new CIMDataType(29))));
                vector.add(new CIMProperty(LOC_CODE_LIST, new CIMValue((Object)stringArray, new CIMDataType(29))));
                vector.add(new CIMProperty(FRU_TYPE_LIST, new CIMValue((Object)stringArray4, new CIMDataType(29))));
                vector.add(new CIMProperty(RESOURCE_STATUS_LIST, new CIMValue((Object)objectArray, new CIMDataType(21))));
                vector.add(new CIMProperty("IndicatorStateList", new CIMValue((Object)unsignedInt8, new CIMDataType(21))));
            }
        }
        catch (Throwable throwable) {
            System.err.println("GetAllLocCodeInfo....Error packing up stuff!!!!");
            throwable.printStackTrace();
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetAllLocCodes");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetAllLocCodeInfo(OmFrameMgr omFrameMgr, Vector vector) throws PIHscServerException {
        UnsignedInt8 unsignedInt8;
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetAllLocCodes");
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<UnsignedInt8> arrayList3 = new ArrayList<UnsignedInt8>();
        ArrayList<UnsignedInt8> arrayList4 = new ArrayList<UnsignedInt8>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        Vector vector2 = new Vector();
        Vector<Object> vector3 = new Vector<Object>();
        boolean bl = false;
        System.out.println("*****************IN BPA LedFunctions");
        String[] stringArray = null;
        String[] stringArray2 = null;
        UnsignedInt8[] unsignedInt8Array = null;
        UnsignedInt8[] unsignedInt8Array2 = null;
        try {
            vector2 = new Vector();
            PILedFunctions.GetEnclosureList(omFrameMgr, vector2);
            if (vector2 != null) {
                if (CALL_BY_VALUE) {
                    stringArray2 = (String[])((CIMValue)vector2.elementAt(0)).getValue();
                    stringArray = (String[])((CIMValue)vector2.elementAt(1)).getValue();
                    unsignedInt8Array2 = (UnsignedInt8[])((CIMValue)vector2.elementAt(2)).getValue();
                    unsignedInt8Array = (UnsignedInt8[])((CIMValue)vector2.elementAt(3)).getValue();
                } else {
                    stringArray2 = (String[])((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                    stringArray = (String[])((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                    unsignedInt8Array2 = (UnsignedInt8[])((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                    unsignedInt8Array = (UnsignedInt8[])((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                }
                System.out.println("LEDFUNCTIONS PROVIDER 1 = " + stringArray2.length);
                for (int i = 0; i < stringArray2.length; ++i) {
                    arrayList.add(ENCL);
                    object = stringArray2[i];
                    arrayList2.add(object);
                    arrayList3.add(unsignedInt8Array[i]);
                    arrayList5.add(stringArray[i]);
                    arrayList4.add(unsignedInt8Array2[i]);
                    System.out.println("CUR ENCLOSURE = " + (String)object);
                    vector2 = new Vector();
                    vector3 = new Vector();
                    if (CALL_BY_VALUE) {
                        vector3.add(0, new CIMValue(object));
                    } else {
                        vector3.add(0, new CIMProperty(ENCLOSURE, new CIMValue(object)));
                    }
                    System.out.println("BEGIN GET ENCLOSURE LOC CODE INFO");
                    PILedFunctions.GetEnclosureLocationCodeInfo(omFrameMgr, vector3, vector2);
                    System.out.println("DONE GET ENCLOSURE LOC CODE INFO");
                    objectArray2 = null;
                    objectArray = null;
                    UnsignedInt8[] unsignedInt8Array3 = null;
                    UnsignedInt8[] unsignedInt8Array4 = null;
                    if (vector2 == null) continue;
                    if (CALL_BY_VALUE) {
                        objectArray2 = (String[])((CIMValue)vector2.elementAt(0)).getValue();
                        objectArray = (String[])((CIMValue)vector2.elementAt(1)).getValue();
                        unsignedInt8Array4 = (UnsignedInt8[])((CIMValue)vector2.elementAt(2)).getValue();
                        unsignedInt8Array3 = (UnsignedInt8[])((CIMValue)vector2.elementAt(3)).getValue();
                    } else {
                        objectArray2 = (String[])((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                        objectArray = (String[])((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                        unsignedInt8Array4 = (UnsignedInt8[])((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                        unsignedInt8Array3 = (UnsignedInt8[])((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                    }
                    for (int j = 0; j < objectArray2.length; ++j) {
                        unsignedInt8 = objectArray2[j];
                        System.out.println("&&&&&&&&&CUR LOC = " + (String)unsignedInt8);
                        if (unsignedInt8.equals(object)) {
                            System.err.println("DevLocation code : " + (String)unsignedInt8 + "Enclosure code : " + (String)object);
                            continue;
                        }
                        arrayList.add(object);
                        System.out.println("******ADD TO LOCLIST");
                        arrayList2.add(unsignedInt8);
                        arrayList3.add(unsignedInt8Array3[j]);
                        arrayList4.add(unsignedInt8Array4[j]);
                        arrayList5.add((String)objectArray[j]);
                    }
                }
            }
        }
        catch (PIHscServerException pIHscServerException) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetAllLocCodeInfo *** Error ***");
                pIHscServerException.printStackTrace();
            }
            throw pIHscServerException;
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetAllLocCodeInfo *** Error ***");
                throwable.printStackTrace();
            }
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (vector == null) {
            vector = new Vector<Object>(5);
        }
        object = arrayList5.toArray(new String[0]);
        String[] stringArray3 = arrayList.toArray(new String[0]);
        unsignedInt8 = arrayList2.toArray(new String[0]);
        objectArray2 = arrayList3.toArray(new UnsignedInt8[0]);
        objectArray = arrayList4.toArray(new UnsignedInt8[0]);
        try {
            if (CALL_BY_VALUE) {
                vector.add(new CIMValue((Object)stringArray3, new CIMDataType(29)));
                vector.add(new CIMValue((Object)unsignedInt8, new CIMDataType(29)));
                vector.add(new CIMValue(object, new CIMDataType(29)));
                vector.add(new CIMValue((Object)objectArray, new CIMDataType(21)));
                vector.add(new CIMValue((Object)objectArray2, new CIMDataType(21)));
            } else {
                vector.add(new CIMProperty(ENCLOSURE_MAP, new CIMValue((Object)stringArray3, new CIMDataType(29))));
                vector.add(new CIMProperty(LOC_CODE_LIST, new CIMValue((Object)unsignedInt8, new CIMDataType(29))));
                vector.add(new CIMProperty(FRU_TYPE_LIST, new CIMValue(object, new CIMDataType(29))));
                vector.add(new CIMProperty(RESOURCE_STATUS_LIST, new CIMValue((Object)objectArray, new CIMDataType(21))));
                vector.add(new CIMProperty("IndicatorStateList", new CIMValue((Object)objectArray2, new CIMDataType(21))));
            }
        }
        catch (Throwable throwable) {
            System.err.println("GetAllLocCodeInfo....Error packing up stuff!!!!");
            throwable.printStackTrace();
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetAllLocCodes");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetLedLocCodeInfo(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        UnsignedInt8 unsignedInt8;
        String[] stringArray;
        UnsignedInt8[] unsignedInt8Array;
        String[] stringArray2;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetLedLocationCodeInfo");
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<void> arrayList3 = new ArrayList<void>();
        ArrayList<void> arrayList4 = new ArrayList<void>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        Vector vector2 = new Vector();
        Vector<Object> vector3 = new Vector<Object>();
        boolean bl = false;
        String[] stringArray3 = null;
        UnsignedInt8[] unsignedInt8Array2 = null;
        String[] stringArray4 = null;
        UnsignedInt8[] unsignedInt8Array3 = null;
        try {
            PILedFunctions.GetEnclosureList(omCecMgr, vector2);
            if (vector2 != null) {
                PILedFunctions._unpackInfo(vector2, stringArray3, stringArray4, unsignedInt8Array3, unsignedInt8Array2);
                vector2 = new Vector();
                vector3 = new Vector(1);
                for (int i = 0; i < stringArray3.length; ++i) {
                    arrayList.add(ENCL);
                    stringArray2 = stringArray3[i];
                    arrayList2.add(stringArray2);
                    arrayList3.add(unsignedInt8Array2[i]);
                    arrayList5.add(stringArray4[i]);
                    arrayList4.add(unsignedInt8Array3[i]);
                    if (CALL_BY_VALUE) {
                        vector3.setElementAt(new CIMValue((Object)stringArray2), 0);
                    } else {
                        vector3.setElementAt(new CIMProperty(ENCLOSURE, new CIMValue((Object)stringArray2)), 0);
                    }
                    try {
                        PILedFunctions.GetEnclosureLocationCodeInfo(omCecMgr, vector3, vector2);
                        unsignedInt8Array = null;
                        stringArray = null;
                        UnsignedInt8[] unsignedInt8Array4 = null;
                        UnsignedInt8[] unsignedInt8Array5 = null;
                        if (vector2 == null) continue;
                        PILedFunctions._unpackInfo(vector2, (String[])unsignedInt8Array, stringArray, unsignedInt8Array5, unsignedInt8Array4);
                        for (int j = 0; j < unsignedInt8Array.length; ++j) {
                            unsignedInt8 = unsignedInt8Array[j];
                            if (unsignedInt8.equals(stringArray2) || !PILedFunctions._isIndicator((UnsignedInt8)unsignedInt8Array5[i])) continue;
                            arrayList.add(stringArray2);
                            arrayList2.add(unsignedInt8);
                            arrayList3.add(unsignedInt8Array4[j]);
                            arrayList4.add(unsignedInt8Array5[j]);
                            arrayList5.add(stringArray[j]);
                        }
                        continue;
                    }
                    catch (PIHscServerException pIHscServerException) {
                        if (PILedFunctions.tracing()) {
                            PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetAllLocCodeInfo *** Error ***");
                            pIHscServerException.printStackTrace();
                        }
                        throw pIHscServerException;
                    }
                }
            }
        }
        catch (PIHscServerException pIHscServerException) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetLedLocCodeInfo *** Error ***");
                pIHscServerException.printStackTrace();
            }
            throw pIHscServerException;
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetLedLocCodeInfo *** Error ***");
                throwable.printStackTrace();
            }
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (vector == null) {
            vector = new Vector<Object>(5);
        }
        stringArray2 = arrayList.toArray(new String[0]);
        String[] stringArray5 = arrayList5.toArray(new String[0]);
        unsignedInt8 = arrayList3.toArray(new UnsignedInt8[0]);
        unsignedInt8Array = arrayList4.toArray(new UnsignedInt8[0]);
        stringArray = arrayList2.toArray(new String[0]);
        if (CALL_BY_VALUE) {
            vector.setElementAt(new CIMValue((Object)stringArray2), 0);
            vector.setElementAt(new CIMValue((Object)stringArray), 1);
            vector.setElementAt(new CIMValue((Object)stringArray5), 2);
            vector.setElementAt(new CIMValue((Object)unsignedInt8Array), 3);
            vector.setElementAt(new CIMValue((Object)unsignedInt8), 4);
        } else {
            vector.setElementAt(new CIMProperty(ENCLOSURE_MAP, new CIMValue((Object)stringArray2)), 0);
            vector.setElementAt(new CIMProperty(LOC_CODE_LIST, new CIMValue((Object)stringArray)), 1);
            vector.setElementAt(new CIMProperty(FRU_TYPE_LIST, new CIMValue((Object)stringArray5)), 2);
            vector.setElementAt(new CIMProperty(RESOURCE_STATUS_LIST, new CIMValue((Object)unsignedInt8Array)), 3);
            vector.setElementAt(new CIMProperty("IndicatorStateList", new CIMValue((Object)unsignedInt8)), 4);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetLedLocationCodeInfo");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetLparSALeds(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetLparSALeds");
        }
        Vector vector3 = null;
        ArrayList<UnsignedInt8> arrayList = new ArrayList<UnsignedInt8>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            try {
                vector3 = CALL_BY_VALUE ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            }
            catch (Throwable throwable) {
                System.err.println("Caught your exception!!!!");
                throwable.printStackTrace();
            }
            Iterator iterator = vector3.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                try {
                    FspVspAttr fspVspAttr = omCecMgr.getCmdHelper().getLparVspAttributes((UnsignedInt16)iterator.next());
                    UnsignedInt8 unsignedInt8 = fspVspAttr.getVirtualServiceAttLed();
                    arrayList.add(n++, unsignedInt8);
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    if (PILedFunctions.tracing()) {
                        PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetLparSALeds *** Error ***");
                        pIHscCmdMgrException.printStackTrace();
                    }
                    if (!pIHscCmdMgrException.alreadyLogged()) {
                        HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                        pIHscCmdMgrException.setAlreadyLogged(true);
                    }
                    throw pIHscCmdMgrException;
                }
            }
            UnsignedInt8[] unsignedInt8Array = arrayList.toArray(new UnsignedInt8[0]);
            if (vector2 == null) {
                vector2 = new Vector<CIMValue>();
            }
            if (CALL_BY_VALUE) {
                vector2.add(0, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21)));
            } else {
                vector2.add(0, (CIMValue)new CIMProperty(LED_STATE_LIST, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
            }
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetLparSALeds *** Error ***");
                throwable.printStackTrace();
            }
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetLparSALeds");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMValue SetLparSALeds(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.SetLparSALeds");
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Vector vector2;
            Vector vector3;
            Object object;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                System.err.println(object);
            }
            if (CALL_BY_VALUE) {
                vector3 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                vector2 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
            } else {
                vector3 = (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector2 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            }
            Iterator iterator2 = vector3.iterator();
            Iterator iterator3 = vector2.iterator();
            while (iterator2.hasNext() && iterator3.hasNext()) {
                object = (UnsignedInt16)iterator2.next();
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)iterator3.next();
                try {
                    FspVspAttr fspVspAttr = new FspVspAttr(null, null, null, unsignedInt8, null, null);
                    omCecMgr.getCmdHelper().setLparVSPAttributes((UnsignedInt16)object, fspVspAttr);
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    if (PILedFunctions.tracing()) {
                        PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetServiceLEDStates *** Error ***");
                        pIHscCmdMgrException.printStackTrace();
                    }
                    if (!pIHscCmdMgrException.alreadyLogged()) {
                        HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                        pIHscCmdMgrException.setAlreadyLogged(true);
                    }
                    throw pIHscCmdMgrException;
                }
            }
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.SetLparSALeds *** Error ***");
                throwable.printStackTrace();
            }
            throwable.printStackTrace();
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.SetLparSALeds");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetPlatformSALed(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        block13: {
            if (PILedFunctions.tracing(Trace.LEVEL)) {
                PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetPlatformSALed");
            }
            StringBuffer stringBuffer = new StringBuffer();
            try {
                UnsignedInt8 unsignedInt8;
                UnsignedInt8 unsignedInt82 = CALL_BY_VALUE ? (UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue() : (UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                try {
                    unsignedInt8 = omCecMgr.getCmdHelper().getServiceAttentionLedState(unsignedInt82);
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    if (PILedFunctions.tracing()) {
                        PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetPlatformSALeds *** Error ***");
                        pIHscCmdMgrException.printStackTrace();
                    }
                    if (!pIHscCmdMgrException.alreadyLogged()) {
                        HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                        pIHscCmdMgrException.setAlreadyLogged(true);
                    }
                    PILedFunctions._processException(stringBuffer, null, null, unsignedInt82.toString(), pIHscCmdMgrException);
                    throw new PIHscServerException(stringBuffer.toString(), pIHscCmdMgrException);
                }
                if (vector2 == null) {
                    vector2 = new Vector<Object>();
                }
                if (unsignedInt8 != null) {
                    if (CALL_BY_VALUE) {
                        vector2.add(0, new CIMValue((Object)unsignedInt8, new CIMDataType(1)));
                    } else {
                        vector2.add(0, new CIMProperty(LED_STATE, new CIMValue((Object)unsignedInt8, new CIMDataType(1))));
                    }
                    break block13;
                }
                throw new PIHscServerException(COMMAND_FAILED_ID);
            }
            catch (Throwable throwable) {
                if (PILedFunctions.tracing()) {
                    PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetPlatformSALed *** Error ***");
                    throwable.printStackTrace();
                }
                throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
            }
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetPlatformSALed");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue SetPlatformSALed(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.SetPlatformSALed");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            UnsignedInt8 unsignedInt8;
            UnsignedInt8 unsignedInt82;
            if (CALL_BY_VALUE) {
                unsignedInt82 = (UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector.elementAt(1)).getValue();
            } else {
                unsignedInt82 = (UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            }
            try {
                omCecMgr.getCmdHelper().setServiceAttentionLedState(unsignedInt82, unsignedInt8);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                if (PILedFunctions.tracing()) {
                    PILedFunctions.trace(TRACE_MASK, "PILedFunctions.setPlatformSALeds *** Error ***");
                    pIHscCmdMgrException.printStackTrace();
                }
                if (!pIHscCmdMgrException.alreadyLogged()) {
                    HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                    pIHscCmdMgrException.setAlreadyLogged(true);
                }
                PILedFunctions._processException(stringBuffer, null, unsignedInt8.toString(), unsignedInt82.toString(), pIHscCmdMgrException);
                throw new PIHscServerException(stringBuffer.toString(), pIHscCmdMgrException);
            }
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.setPlatformSALed *** Error ***");
                throwable.printStackTrace();
            }
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.SetPlatformSAled");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetIdentifyIndicatorStates(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetIdentifyIndicatorStates");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Vector vector3 = null;
        ArrayList<UnsignedInt8> arrayList = new ArrayList<UnsignedInt8>();
        try {
            vector3 = CALL_BY_VALUE ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            String[] stringArray = new String[4];
            Iterator iterator = vector3.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (PILedFunctions.tracing()) {
                    PILedFunctions.trace(TRACE_MASK, "Command args : location Code = " + string);
                }
                PIFspString pIFspString = new PIFspString(string);
                int n2 = pIFspString.getRawLength();
                String string2 = pIFspString.getPaddedHexString();
                int n3 = pIFspString.getPaddedLength();
                stringArray[0] = Integer.toString(n2);
                stringArray[1] = Integer.toString(n3);
                stringArray[2] = string2;
                try {
                    UnsignedInt8 unsignedInt8 = omCecMgr.getCmdHelper().getIdentifyIndicatorState(stringArray);
                    arrayList.add(n++, unsignedInt8);
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    if (PILedFunctions.tracing()) {
                        PILedFunctions.trace(TRACE_MASK, "PILedFunctions.getIdentifyIndicatorStates *** Error ***");
                        pIHscCmdMgrException.printStackTrace();
                    }
                    if (!pIHscCmdMgrException.alreadyLogged()) {
                        HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                        pIHscCmdMgrException.setAlreadyLogged(true);
                    }
                    PILedFunctions._processException(stringBuffer, string, null, null, pIHscCmdMgrException);
                    throw new PIHscServerException(stringBuffer.toString(), pIHscCmdMgrException);
                }
            }
            if (vector2 == null) {
                vector2 = new Vector<Object>(1);
            }
            UnsignedInt8[] unsignedInt8Array = arrayList.toArray(new UnsignedInt8[0]);
            if (CALL_BY_VALUE) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt8Array, new CIMDataType(21)), 0);
            } else {
                vector2.setElementAt(new CIMProperty("IndicatorStateList", new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))), 0);
            }
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetIndentifyIndicatorStates *** Error ***");
                throwable.printStackTrace();
            }
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetIdentifyIndicatorStates");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue GetIdentifyIndicatorStates(OmFrameMgr omFrameMgr, Vector vector, Vector vector2) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.GetIdentifyIndicatorStates");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Vector vector3 = null;
        ArrayList<UnsignedInt8> arrayList = new ArrayList<UnsignedInt8>();
        try {
            vector3 = CALL_BY_VALUE ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            String[] stringArray = new String[4];
            Iterator iterator = vector3.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (PILedFunctions.tracing()) {
                    PILedFunctions.trace(TRACE_MASK, "Command args : location Code = " + string);
                }
                System.out.println("^^^^^LOCCODE = '" + string + "'");
                PIFspString pIFspString = new PIFspString(string);
                System.out.println("^^^^^FSPSTRING = " + pIFspString);
                int n2 = pIFspString.getRawLength();
                String string2 = pIFspString.getPaddedHexString();
                int n3 = pIFspString.getPaddedLength();
                int n4 = n3 + 4;
                stringArray[0] = Integer.toString(n4);
                stringArray[1] = Integer.toString(n2);
                stringArray[2] = Integer.toString(n3);
                stringArray[3] = string2;
                try {
                    System.out.println("##########ABOUT TO CALL COMAND HELPER");
                    UnsignedInt8 unsignedInt8 = omFrameMgr.getCmdHelper().getBpaIdentifyIndicatorState(stringArray);
                    arrayList.add(n++, unsignedInt8);
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    if (PILedFunctions.tracing()) {
                        PILedFunctions.trace(TRACE_MASK, "PILedFunctions.getIdentifyIndicatorStates *** Error ***");
                        pIHscCmdMgrException.printStackTrace();
                    }
                    if (!pIHscCmdMgrException.alreadyLogged()) {
                        HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                        pIHscCmdMgrException.setAlreadyLogged(true);
                    }
                    PILedFunctions._processException(stringBuffer, string, null, null, pIHscCmdMgrException);
                    throw new PIHscServerException(stringBuffer.toString(), pIHscCmdMgrException);
                }
            }
            if (vector2 == null) {
                vector2 = new Vector<Object>(1);
            }
            UnsignedInt8[] unsignedInt8Array = arrayList.toArray(new UnsignedInt8[0]);
            if (CALL_BY_VALUE) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt8Array, new CIMDataType(21)), 0);
            } else {
                vector2.setElementAt(new CIMProperty("IndicatorStateList", new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))), 0);
            }
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.GetIndentifyIndicatorStates *** Error ***");
                throwable.printStackTrace();
            }
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.GetIdentifyIndicatorStates");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMValue SetIdentifyIndicatorStates(OmCecMgr omCecMgr, Vector vector) throws PIHscServerException {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Object var6_6 = null;
        boolean bl = false;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.SetIdentifyIndicatorStates");
        }
        try {
            if (CALL_BY_VALUE) {
                vector2 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
            } else {
                vector2 = (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
            }
            String[] stringArray = new String[6];
            Iterator iterator = vector2.iterator();
            Iterator iterator2 = vector3.iterator();
            Iterator iterator3 = vector4.iterator();
            while (iterator.hasNext() && iterator2.hasNext() && iterator3.hasNext()) {
                String string = (String)iterator.next();
                String string2 = ((UnsignedInt8)iterator2.next()).toString();
                String string3 = SET_INDICATOR_MAP[((UnsignedInt8)iterator3.next()).intValue()].toString();
                if (PILedFunctions.tracing()) {
                    PILedFunctions.trace(TRACE_MASK, "Command args..\nlocation : " + string + "state : " + string2 + "type : " + string3);
                }
                PIFspString pIFspString = new PIFspString(string);
                String string4 = pIFspString.getPaddedHexString();
                System.out.println("@@@@HEXSTRING = " + string4);
                stringArray[1] = string3;
                stringArray[2] = string2;
                int n = pIFspString.getRawLength();
                stringArray[3] = Integer.toString(n);
                int n2 = pIFspString.getPaddedLength();
                stringArray[4] = Integer.toString(n2);
                stringArray[5] = string4;
                int n3 = 10 + n2;
                stringArray[0] = Integer.toString(n3);
                try {
                    omCecMgr.getCmdHelper().setIdentifyIndicator(stringArray);
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    if (PILedFunctions.tracing()) {
                        PILedFunctions.trace(TRACE_MASK, "PILedFunctions.SetIdentifyIndicatorStates *** Error ***");
                        pIHscCmdMgrException.printStackTrace();
                    }
                    if (!pIHscCmdMgrException.alreadyLogged()) {
                        HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                        pIHscCmdMgrException.setAlreadyLogged(true);
                    }
                    PILedFunctions._processException(stringBuffer, string, string2, string3, pIHscCmdMgrException);
                    throw new PIHscServerException(stringBuffer.toString(), pIHscCmdMgrException);
                }
            }
        }
        catch (PIHscServerException pIHscServerException) {
            throw pIHscServerException;
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.SetIdentifyIndicatorStates *** Error ***");
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.SetIdentifyIndicatorStates");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMValue SetIdentifyIndicatorStates(OmFrameMgr omFrameMgr, Vector vector) throws PIHscServerException {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Object var6_6 = null;
        boolean bl = false;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.SetIdentifyIndicatorStates");
        }
        try {
            if (CALL_BY_VALUE) {
                vector2 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
            } else {
                vector2 = (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
            }
            String[] stringArray = new String[6];
            Iterator iterator = vector2.iterator();
            Iterator iterator2 = vector3.iterator();
            Iterator iterator3 = vector4.iterator();
            while (iterator.hasNext() && iterator2.hasNext() && iterator3.hasNext()) {
                String string = (String)iterator.next();
                String string2 = ((UnsignedInt8)iterator2.next()).toString();
                String string3 = SET_INDICATOR_MAP[((UnsignedInt8)iterator3.next()).intValue()].toString();
                System.out.println("^^^^^^^CODE = " + string);
                System.out.println("^^^^^^^STATE = " + string2);
                System.out.println("^^^^^^TYPE = " + string3);
                if (PILedFunctions.tracing()) {
                    PILedFunctions.trace(TRACE_MASK, "Command args..\nlocation : " + string + "state : " + string2 + "type : " + string3);
                }
                PIFspString pIFspString = new PIFspString(string);
                String string4 = pIFspString.getPaddedHexString();
                stringArray[1] = string3;
                stringArray[2] = string2;
                int n = pIFspString.getRawLength();
                stringArray[3] = Integer.toString(n);
                int n2 = pIFspString.getPaddedLength();
                stringArray[4] = Integer.toString(n2);
                stringArray[5] = string4;
                int n3 = 10 + n2;
                stringArray[0] = Integer.toString(n3);
                try {
                    omFrameMgr.getCmdHelper().setIdentifyIndicator(stringArray);
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    if (PILedFunctions.tracing()) {
                        PILedFunctions.trace(TRACE_MASK, "PILedFunctions.SetIdentifyIndicatorStates *** Error ***");
                        pIHscCmdMgrException.printStackTrace();
                    }
                    if (!pIHscCmdMgrException.alreadyLogged()) {
                        HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                        pIHscCmdMgrException.setAlreadyLogged(true);
                    }
                    PILedFunctions._processException(stringBuffer, string, string2, string3, pIHscCmdMgrException);
                    throw new PIHscServerException(stringBuffer.toString(), pIHscCmdMgrException);
                }
            }
        }
        catch (PIHscServerException pIHscServerException) {
            throw pIHscServerException;
        }
        catch (Throwable throwable) {
            if (PILedFunctions.tracing()) {
                PILedFunctions.trace(TRACE_MASK, "PILedFunctions.SetIdentifyIndicatorStates *** Error ***");
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException(COMMAND_FAILED_ID, throwable);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.SetIdentifyIndicatorStates");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public static CIMValue LampTest(OmCecMgr omCecMgr) throws PIHscServerException {
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions.LampTest");
        }
        try {
            omCecMgr.getCmdHelper().startLampTest();
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (PILedFunctions.tracing()) {
                System.err.println("PILedFunctions.LampTest *** Error ***");
                pIHscCmdMgrException.printStackTrace();
            }
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            throw pIHscCmdMgrException;
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions.LampTest");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    private static void trace(String string, String string2) {
        Trace.trace(string, string2);
    }

    private static boolean tracing() {
        return 3 <= Trace.LEVEL;
    }

    private static boolean tracing(int n) {
        return n <= Trace.LEVEL;
    }

    private static void _processException(StringBuffer stringBuffer, String string, String string2, String string3, PIHscCmdMgrException pIHscCmdMgrException) {
        String string4;
        switch (pIHscCmdMgrException.getStatus()) {
            case 3: {
                String[] stringArray = new String[]{string};
                string4 = HSCResourceBundleUtil.encodeNLSMsg(BUNDLE_FILE, INVALID_DATA_ID, null, stringArray);
                break;
            }
            case 258: {
                String[] stringArray = new String[]{string2, string};
                string4 = HSCResourceBundleUtil.encodeNLSMsg(BUNDLE_FILE, INVALID_INDICATOR_ID, null, stringArray);
                break;
            }
            case 257: {
                string4 = HSCResourceBundleUtil.encodeNLSMsg(BUNDLE_FILE, INDICATOR_BUSY_ID);
                break;
            }
            case 261: {
                Hashtable hashtable = (Hashtable)pIHscCmdMgrException.getSecondaryStatusData();
                String string5 = "[Origin: " + Long.toHexString(((UnsignedInt16)hashtable.get("STATUS_ORIGIN")).longValue()) + ", Code: " + Long.toHexString(((UnsignedInt16)hashtable.get("STATUS_CODE")).longValue()) + "]";
                String[] stringArray = new String[]{string5};
                string4 = HSCResourceBundleUtil.encodeNLSMsg(BUNDLE_FILE, INDICATOR_CMMD_FAILED_ID, null, stringArray);
                break;
            }
            case 262: {
                string4 = HSCResourceBundleUtil.encodeNLSMsg(BUNDLE_FILE, INDICATOR_REQ_TYPE_ID);
                break;
            }
            case 28: {
                string4 = HSCResourceBundleUtil.encodeNLSMsg(BUNDLE_FILE, COMMAND_BUSY_ID);
                break;
            }
            default: {
                string4 = HSCResourceBundleUtil.encodeNLSMsg(BUNDLE_FILE, COMMAND_FAILED_ID);
            }
        }
        stringBuffer.append(string4 + "\n");
    }

    private static Iterator _getLocationCodeInfo(OmCecMgr omCecMgr, UnsignedInt16 unsignedInt16, PIFspString pIFspString) throws PIHscServerException {
        Iterator iterator;
        int n;
        int n2;
        String string;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> PILedFunctions._getLocationCodeInfo");
        }
        int n3 = 6;
        StringBuffer stringBuffer = new StringBuffer();
        if (pIFspString == null) {
            pIFspString = new PIFspString("DummyString");
            string = new String();
            n2 = 0;
            n = 0;
        } else {
            string = pIFspString.getPaddedHexString();
            n2 = pIFspString.getRawLength();
            n = pIFspString.getPaddedLength();
        }
        String[] stringArray = new String[]{Integer.toString(n3 += n), unsignedInt16.toString(), Integer.toString(n2), Integer.toString(n), string};
        try {
            iterator = omCecMgr.getCmdHelper().getLocationCodeInfo(stringArray);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            System.out.println("PILedFunctions._getLocationCodeInfo *** Error ***");
            pIHscCmdMgrException.printStackTrace();
            if (PILedFunctions.tracing()) {
                System.err.println("PILedFunctions._getLocationCodeInfo *** Error ***");
                pIHscCmdMgrException.printStackTrace();
            }
            if (pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            PILedFunctions._processException(stringBuffer, pIFspString.toString(), null, unsignedInt16.toString(), pIHscCmdMgrException);
            String[] stringArray2 = new String[]{stringBuffer.toString()};
            throw new PIHscServerException(FOLLOWING_ERRORS_ID, stringArray2, null);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions._getLocationCodeInfo");
        }
        return iterator;
    }

    private static Vector _getLocationCodeInfo(OmFrameMgr omFrameMgr, UnsignedInt16 unsignedInt16, PIFspString pIFspString) throws PIHscServerException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = null;
        int n = 6;
        int n2 = 0;
        int n3 = 0;
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "-> BPA PILedFunctions._getLocationCodeInfo");
        }
        if (pIFspString == null) {
            System.out.println("LOCATION CODE IS NULL");
            pIFspString = new PIFspString("DummyString");
            string = new String(" ");
            n3 = 0;
            n2 = 0;
        } else {
            System.out.println("LOCATION CODE IS NOT NULL");
            string = pIFspString.getPaddedHexString();
            n3 = pIFspString.getRawLength();
            n2 = pIFspString.getPaddedLength();
        }
        String[] stringArray = new String[]{Integer.toString(n += n2), unsignedInt16.toString(), Integer.toString(n3), Integer.toString(n2), string};
        try {
            vector = omFrameMgr.getCmdHelper().getBpaLocationCodeInfo(stringArray);
            System.out.println("############_getLocationCOdeInfo size = " + vector.size());
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            System.out.println("BPA PILedFunctions._getLocationCodeInfo *** Error ***");
            pIHscCmdMgrException.printStackTrace();
            if (PILedFunctions.tracing()) {
                System.err.println("PILedFunctions._getLocationCodeInfo *** Error ***");
                pIHscCmdMgrException.printStackTrace();
            }
            if (pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            PILedFunctions._processException(stringBuffer, pIFspString.toString(), null, unsignedInt16.toString(), pIHscCmdMgrException);
            String[] stringArray2 = new String[]{stringBuffer.toString()};
            throw new PIHscServerException(FOLLOWING_ERRORS_ID, stringArray2, null);
        }
        if (PILedFunctions.tracing(Trace.LEVEL)) {
            PILedFunctions.trace(TRACE_MASK, "<- PILedFunctions._getLocationCodeInfo");
        }
        return vector;
    }

    private static UnsignedInt8 _statusToUint8(BitSet bitSet) {
        byte[] byArray = ByteUtilities.bitSetToByteArray(bitSet, 1);
        short s = ByteUtilities.byteArrayToShort(byArray);
        return new UnsignedInt8(s);
    }

    private static void _unpackInfo(Vector vector, String[] stringArray, String[] stringArray2, UnsignedInt8[] unsignedInt8Array, UnsignedInt8[] unsignedInt8Array2) {
    }

    private static boolean _isIndicator(UnsignedInt8 unsignedInt8) {
        int n = 12;
        if (unsignedInt8 == null) {
            return false;
        }
        short s = unsignedInt8.shortValue();
        return (s & n) == 4;
    }
}

